﻿using System.Globalization;
using System.Collections.Generic;
using System.Runtime.CompilerServices;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Text;

namespace PersonSearch.Plugin.VistA
{
    class VistaService
    {
        public static string CrmIdToVistaId(Guid crmId)
        {
            return new VistaPatientKey(crmId).VistaId;
        }

        public static string CrmIdToSiteCode(Guid crmId)
        {
            return new VistaPatientKey(crmId).SiteCode;
        }

        public static Guid VistaIdToCrmId(string vistaId, string siteCode)
        {
            return new VistaPatientKey(vistaId, siteCode).CrmId; 
        }

        public static EntityReference GetPatientReference(Guid crmPatientId)
        {
            return new EntityReference {LogicalName = "contact", Id = crmPatientId};
        }

        public static Guid IntegerToCrmId(int integerValue)
        {
            string crmidstring = string.Empty;
            
            if (integerValue < 0)
            {
                crmidstring = "f";
                integerValue = integerValue * -1;
            }

            crmidstring = crmidstring + integerValue.ToString(CultureInfo.InvariantCulture);

            crmidstring = crmidstring.PadRight(32, 'f');

            return new Guid(crmidstring);
        }

        public static int CrmIdToInteger(Guid crmId)
        {
            string idstring = crmId.ToString("N").ToLower();
            bool isnegative = false;

            if (idstring.StartsWith("f"))
            {
                idstring = idstring.Substring(1);
                isnegative = true;
            }

            if (idstring.Contains("f"))
                idstring = idstring.Substring(0, idstring.IndexOf('f'));

            int result;

            if (!int.TryParse(idstring, out result))
                throw new ApplicationException("Invalid crmId");

            if (isnegative)
                result = result * -1;

            return result;
        }

        public static Guid GetCrmIdFromTimestamp(string timeStamp, Guid patientId)
        {
            var idstring = timeStamp.Remove(timeStamp.IndexOf('.'), 1);

            idstring = string.Format("{0}F{1}", idstring, patientId.ToString("N").ToLower().TrimEnd('f'));

            return new Guid(idstring.PadRight(32, 'f'));
        }

        public static string GetTimestampFromCrmId(Guid crmId)
        {
            var crmidstring = crmId.ToString("N").ToLower();

            crmidstring = crmidstring.Substring(0, crmidstring.IndexOf('f'));

            return string.Format("{0}.{1}", crmidstring.Substring(0, 8), crmidstring.Substring(8));
        }

        public static string GetPatientVistaIdFromCrmTimestampId(Guid crmId)
        {
            return GetSiteCodePlusPatientIdFromCrmTimestampId(crmId).Substring(3);
        }

        public static string GetSiteCodeFromCrmTimestampId(Guid crmId)
        {
            return GetSiteCodePlusPatientIdFromCrmTimestampId(crmId).Substring(0, 3);
        }

        internal static string GetSiteCodePlusPatientIdFromCrmTimestampId(Guid crmId)
        {
            string crmidstring = crmId.ToString("N").ToLower();
            int delimpos = crmidstring.IndexOf('f');
            return crmidstring.Substring(
                 delimpos + 1,
                 crmidstring.IndexOf('f', delimpos + 1) - delimpos - 1);
        }

        public static Dictionary<string, string> ParsePatientName(string patientFullName)
        {
            Dictionary<string, string> patientname = new Dictionary<string, string>();
            patientFullName = patientFullName.Trim();
            int spaceposition;
            if (!patientFullName.Contains(","))
            {
                if (patientFullName.Contains(" "))
                {
                    spaceposition = patientFullName.LastIndexOf(" ");
                    patientname.Add("firstname", patientFullName.Substring(0, spaceposition));
                    patientname.Add("lastname", patientFullName.Substring(spaceposition + 1));
                }
            }
            else
            {
                patientname.Add("lastname",
                    patientFullName.Substring(0, patientFullName.IndexOf(",")));

                patientname.Add("firstname",
                    patientFullName.Substring(patientFullName.IndexOf(",") + 1));
            }

            if (patientname.ContainsKey("firstname"))
            {
                if (patientname["firstname"].Contains(" "))
                {
                    spaceposition = patientname["firstname"].IndexOf(" ");
                    patientname.Add("middlename", patientname["firstname"].Substring(spaceposition + 1));
                    patientname["firstname"] = patientname["firstname"].Substring(0, spaceposition);
                }
            }
            return patientname;
        }
    }
}
